﻿(function($) {
    $.fn.extend({
        jump: function() {
            var target = this;
            //建立分身
            var shadow = target.clone().appendTo("body");
            var origVis = target.css("visibility");
            //隱藏本尊, 但要保留其佔用空間
            target.css("visibility", "hidden");
            shadow //設定為絕對座標，以便任意移動
                .css({
                    position: "absolute",
                    top: target.offset().top,
                    left: target.offset().left,
                    margin: "0px"
                }) //進行三次位移
                .animate({ marginTop: "-=10px" }, 100)
                .animate({ marginTop: "+=20px" }, 100)
                .animate({ marginTop: "-=10px" }, 100, function() {
                    //本尊重現
                    target.css("visibility", origVis);
                    //分身移除
                    $(this).remove();
                });

        },
        shake: function() {
            var target = this;
            var shadow = target.clone().appendTo("body");
            var origVis = target.css("visibility");
            target.css("visibility", "hidden");
            shadow 
                .css({
                    position: "absolute",
                    top: target.offset().top,
                    left: target.offset().left,
                    margin: "0px"
                })
                .animate({ marginLeft: "-=10px" }, 100)
                .animate({ marginLeft: "+=20px" }, 100)
                .animate({ marginLeft: "-=10px" }, 100, function() {
                    target.css("visibility", origVis);
                    $(this).remove();
                });        
        }
    });
})(jQuery);