﻿(function($) {
    function moveElem(target, moveAttr) {
        //建立分身
        var shadow = target.clone().appendTo("body");
        var origVis = target.css("visibility");
        //將原元素藏起來
        target.css("visibility", "hidden");
        //建立位移的animiate()參數
        var opt1 = {}, opt2 = {};
        opt1[moveAttr] = "-=10px";
        opt2[moveAttr] = "+=20px";
        shadow  //設定為絕對座標，以便任意移動
            .css({
                position: "absolute",
                top: target.offset().top,
                left: target.offset().left,
                margin: "0px"
            }) //進行三次位移
            .animate(opt1, 100)
            .animate(opt2, 100)
            .animate(opt1, 100, function() {
                //本尊重現
                target.css("visibility", origVis);
                //分身移除
                $(this).remove();
            });
    }

    $.fn.extend({
        jump: function() {
            moveElem(this, "marginTop");
        },
        shake: function() {
            moveElem(this, "marginLeft");
        }
    });
})(jQuery);