﻿(function($) {
    function moveElem(target, moveAttr, options) {
        //處理參數
        var settings = { duration: 100, movement: 10, oncomplete: null };
        $.extend(settings, options);
        //建立分身
        var shadow = target.clone().appendTo("body");
        var origVis = target.css("visibility");
        //將原元素藏起來
        target.css("visibility", "hidden");
        //建立位移的animiate()參數
        var opt1 = {}, opt2 = {};
        opt1[moveAttr] = "-=" + settings.movement + "px";
        opt2[moveAttr] = "+=" + (settings.movement * 2) + "px";
        shadow  //設定為絕對座標，以便任意移動
            .css({
                position: "absolute",
                top: target.offset().top,
                left: target.offset().left,
                margin: "0px"
            }) //進行三次位移
            .animate(opt1, settings.duration)
            .animate(opt2, settings.duration)
            .animate(opt1, settings.duration, function() {
                //本尊重現
                target.css("visibility", origVis);
                //分身移除
                $(this).remove();
                //如有callback，呼叫之
                if ($.isFunction(settings.oncomplete))
                    settings.oncomplete();
            });
    }

    $.fn.extend({
        jump: function(options) {
            moveElem(this, "marginTop", options);
        },
        shake: function(options) {
            moveElem(this, "marginLeft", options);
        }
    });
})(jQuery);